<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fr="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/ForeignTrader.xsd" xmlns:ns1="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/ZPNW.xsd" xmlns:ns2="http://www.w3.org/2000/09/xmldsig#" xmlns:ns3="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/Types.xsd" xmlns:ns4="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/Trader.xsd" xmlns:ns5="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/ForeignTrader.xsd" xmlns:tp="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/Types.xsd" xmlns:tr="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/Trader.xsd" xmlns:zpnw="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/ZPNW.xsd" version="1.0"><xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/><xsl:output encoding="UTF-8" method="html"/><xsl:template match="/"><xsl:apply-templates select="*"/></xsl:template><!-- POCZATEK ALL --><!-- STYL ARKUSZA --><xsl:template match="*" mode="styl1"><style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style><style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style><style type="text/css">a{color:#3366FF;font-weight:bold;}</style><style type="text/css">h3{padding:3px;cursor:help;}</style><style type="text/css">h4,h5,.copyr{text-align:center;}</style><style type="text/css">caption{font-weight:bold;}</style><style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style><style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style><style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style><style type="text/css">#cont{display:none}</style><style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style><style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style><style type="text/css">.nag2{font-size: 20px}</style><style type="text/css">.cz10 {font-size: 10px}</style><style type="text/css">.cz12 {	font-size: 12px}</style><style type="text/css">.cz18 {font-size: 18px}</style><style type="text/css">.cz16 {font-size: 16px}</style><style type="text/css">.cz14 {font-size: 14px}</style></xsl:template><!-- SZABLON STOPKI --><xsl:template match="*" mode="stopka"><xsl:value-of select="name()"/></xsl:template><xsl:template match="*"><!-- ZASTOSOWANIE STYLU --><xsl:apply-templates mode="styl1" select="*"/><!-- DEKLARACJE AKCYZOWE --><xsl:apply-templates mode="dekl_ZPNW" select="."/></xsl:template><!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH --><xsl:template match="*" mode="dekl_ZPNW"><xsl:apply-templates mode="styl2" select="."/><xsl:for-each select="ns1:Header | zpnw:Header | ns4:* | tr:*"><!-- SZABLON IDENTYFIKATORA DLA AKC4 --><xsl:apply-templates mode="Ident" select="."/><!-- SZABLON DLA RODZAJU DEKLARACJI --><xsl:apply-templates mode="rodz_dekl" select="."/><xsl:apply-templates mode="MiejsceDekl" select="."/><xsl:apply-templates mode="RodzZab" select="."/><xsl:apply-templates mode="DaneZglaszajacego" select="ns1:Declarant | zpnw:Declarant  | ns4:* | tr:* | ns5:* "/><xsl:apply-templates mode="AdresZglaszajacego" select="ns1:Declarant | zpnw:Declarant | ns4:* | tr:* | ns5:* "/><xsl:apply-templates mode="DaneNadawcy" select="ns1:Consignor | zpnw:Consignor | ns4:* | tr:* | ns5:*"/><xsl:apply-templates mode="AdresNadawcy" select="ns1:Consignor | zpnw:Consignor | ns4:* | tr:* | ns5:*"/><xsl:apply-templates mode="DaneReprezentanta" select="ns1:Representative | zpnw:Representative | ns4:* | tr:* | ns5:*"/><!-- <xsl:apply-templates select="." mode = "dane_ZPNW"/> --><xsl:apply-templates mode="Wyroby" select="."/><xsl:apply-templates mode="OswPodatnika" select="."/><xsl:apply-templates mode="Adnotacje" select="."/><xsl:apply-templates mode="ObjasnieniaAkc" select="."/><!-- ..................... --></xsl:for-each></xsl:template><!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--><xsl:template match="*" mode="Ident"><table border="1" width="955"><tr align="left" valign="top"><td align="left" height="45" valign="middle" width="586"><span class="cz12"><b>1. Numer Identyfikacji Podatkowej składającego</b></span></td><td align="center" valign="middle" width="353"><span class="nag2"><b><xsl:value-of select="@identifier"/></b></span></td></tr><tr align="left" valign="top"><td align="left" height="45" valign="top"><b>2. Numer własny:</b><span class="cz18"><xsl:value-of select="@selfRef"/></span><br/><b>Data wypełnienia deklaracji:</b><span class="cz18"><xsl:value-of select="//@declarationDate"/></span></td><td align="center" valign="bottom"><xsl:if test="@refNumber"> Nr referencyjny nadany przez System Zefir:<br/><xsl:value-of select="@refNumber"/></xsl:if></td></tr></table></xsl:template><!-- SZABLON DOT.  RODZAJU DEKLARACJI --><xsl:template match="*" mode="rodz_dekl"><xsl:if test="ns1:* | zpnw:*"><table width="955"><tr><td align="center" valign="middle"><div class="cz16"><b> ZGŁOSZENIE O PLANOWANYM NABYCIU WEWNĄTRZWSPÓLNOTOWYM <br/> WYROBÓW AKCYZOWYCH ZNAJDUJĄCYCH SIĘ POZA PROCEDURĄ ZAWIESZENIA POBORU AKCYZY<br/> NA POTRZEBY WYKONYWANEJ NA TERYTORIUM KRAJU DZIAŁALNOŚCI GOSPODARCZEJ</b></div></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --><xsl:template match="*" mode="MiejsceDekl"><xsl:if test="ns1:* | zpnw:*"><table border="1" width="955"><tr align="left" valign="top"><td colspan="2"><b>3. Cel złożenia zgłoszenia</b>(zaznaczyć właściwy kwadrat)</td></tr><tr align="left" valign="top"><td width="472">1. złożenie zgłoszenia <xsl:if test="@submissionAim and normalize-space(@submissionAim)='Deklaracja'"><br/><span class="cz18"><b>X - </b><xsl:value-of select="@submissionAim"/></span></xsl:if></td><td width="467">2. korekta zgłoszenia <xsl:if test="@submissionAim and normalize-space(@submissionAim)='Korekta'"><br/><span class="cz18"><b>X - </b><xsl:value-of select="@submissionAim"/></span><br/><xsl:value-of select="@justification"/></xsl:if></td></tr></table><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="3"><span class="nag1">A. MIEJSCE SKŁADANIA ZGŁOSZENIA</span></td></tr><tr><td bgcolor="#CCCCCC" width="50"/><td align="left" colspan="2" valign="top"><b>4. Urząd celny przyjmujący zgłoszenie</b><br/><br/><span class="cz18"><xsl:value-of select="//@customsOffice"/></span></td></tr><tr><td bgcolor="#CCCCCC"/><td align="left" valign="top"><b>5. Data wypełnienia zgłoszenia (rok-miesiąc-dzień):</b><br/><br/><span class="cz18"><xsl:value-of select="//@declarationDate"/></span></td><td align="left" valign="top"><b>6. Przewidywana data dostawy (rok-miesiąc-dzień)</b><br/><br/><span class="cz18"><xsl:value-of select="//@expectedDateOfArrival"/></span></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. Rodzaju zabezpieczenia --><xsl:template match="*" mode="RodzZab"><xsl:if test="ns1:* | zpnw:*"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="3"><span class="nag2">A.1. RODZAJ ZABEZPIECZENIA</span></td></tr><tr><td bgcolor="#CCCCCC" width="50"/><td align="left" valign="top" width="412"><b>7. Rodzaj zabezpieczenia</b><br/><br/><xsl:choose><xsl:when test="//@type='JEDN'"><span class="cz18">jednorazowe</span></xsl:when><xsl:when test="//@type='GEN'"><span class="cz18">generalne</span></xsl:when><xsl:otherwise><xsl:text> ... </xsl:text></xsl:otherwise></xsl:choose></td><td align="left" valign="top" width="471"><b>8. Numer zabezpieczenia</b><br/><br/><span class="cz18"><xsl:value-of select="//@number"/></span></td></tr><tr><td bgcolor="#CCCCCC"/><td align="left" valign="top"><b>9. Data złożenia zabezpieczenia</b><br/><br/><span class="cz18"><xsl:value-of select="//@date"/></span></td><td align="left" valign="top"><b>10. Kwota zabezpieczenia akcyzowego <sup>2) 3)</sup></b><br/><br/><span class="cz18"><xsl:value-of select="//@amountOfExciseGuarantee"/></span></td></tr></table></xsl:if></xsl:template><xsl:template match="ns1:Declarant | zpnw:Declarant  | ns4:* | tr:* | ns5:*  " mode="DaneZglaszajacego"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="4"><span class="nag1">B.DANE PODMIOTU ZGŁASZAJĄCEGO<sup>1)</sup></span><br/> *- dotyczy podmiotów niebędących osobami fizycznymi **- dotyczy podmiotów będących osobami fizycznymi </td></tr><tr bgcolor="#CCCCCC"><td colspan="4"><span class="nag2">B.1 DANE IDENTYFIKACYJNE </span></td></tr><tr><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td align="left" colspan="3" valign="top"><b>11. Rodzaj podmiotu (zaznaczyć właściwy kwadrat): </b></td></tr><tr><td align="left" valign="top">1. podmiot niebędący osobą fizyczną<br/><xsl:for-each select=".//tr:Trader  | .//ns4:Trader "><b><span class="cz18">X</span></b></xsl:for-each></td><td align="left" valign="top" width="425">2. osoba fizyczna <br/><xsl:for-each select=".//tr:PrivatePerson | .//ns4:PrivatePerson"><b><span class="cz18">X</span></b></xsl:for-each></td></tr><tr><td align="left" colspan="3" valign="top"><b>12. Nazwa pełna podmiotu/ dane osobowe (imię, nazwisko, data urodzenia) </b><br/><br/><xsl:for-each select=".//tr:TaxpayerData | .//ns4:TaxpayerData "><span class="cz18"><xsl:value-of select=".//@fullName"/></span><span class="cz18"><xsl:value-of select=".//@REGON"/></span></xsl:for-each><xsl:for-each select=".//tr:PrivatePerson | .//ns4:PrivatePerson"><span class="cz18"><xsl:value-of select=".//@firstName"/></span><span class="cz18"><xsl:value-of select=".//@surname"/></span><span class="cz18"><xsl:value-of select=".//@dateOfBirth"/></span><span class="cz18"><xsl:value-of select=".//@PESEL"/></span></xsl:for-each></td></tr></table></xsl:template><xsl:template match="ns1:Declarant | zpnw:Declarant  | ns4:* | tr:* | ns5:*  " mode="AdresZglaszajacego"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="6"><span class="nag2">B.2. ADRES SIEDZIBY* / ADRES ZAMIESZKANIA** </span></td></tr><tr align="left" valign="top"><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td width="269"><b>13. Kraj </b><br/><span class="cz18"><xsl:value-of select=".//@country"/></span></td><td colspan="2"><b>14. Województwo</b><br/><span class="cz18"><xsl:value-of select=".//@province"/></span></td><td colspan="2"><b>15. Powiat</b><br/><span class="cz18"><xsl:value-of select=".//@district"/></span></td></tr><tr align="left" valign="top"><td><b>16. Gmina </b><br/><span class="cz18"><xsl:value-of select=".//@commune"/></span></td><td colspan="2"><b>17. Ulica</b><br/><span class="cz18"><xsl:value-of select=".//@street"/></span></td><td width="144"><b>18. Nr domu</b><br/><span class="cz18"><xsl:value-of select=".//@houseNumber"/></span></td><td width="151"><b>19. Nr lokalu</b><br/><span class="cz18"><xsl:value-of select=".//@localNumber"/></span></td></tr><tr align="left" valign="top"><td><b>20. Miejscowość</b><br/><span class="cz18"><xsl:value-of select=".//@city"/></span></td><td width="130"><b>21. Kod pocztowy</b><br/><span class="cz18"><xsl:value-of select=".//@postalCode"/></span></td><td width="181"><b>22. Poczta</b><br/><span class="cz18"><xsl:value-of select=".//@postalName"/></span></td><td colspan="2"><b> Adres e-mail i nr telefonu</b><br/><span class="cz18"><xsl:value-of select=".//@email"/>;</span><br/><span class="cz18"><xsl:value-of select=".//@phone"/></span></td></tr></table></xsl:template><xsl:template match="zpnw:Representative | ns1:Representative" mode="DaneReprezentanta"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="3"><span class="nag1"><b>DANE REPREZENTANTA</b></span></td></tr><tr><td bgcolor="#CCCCCC" rowspan="2" width="46"/><td align="left" valign="top" width="413"><b>21.Imię</b><br/><br/><span class="cz18"><xsl:value-of select=".//@firstName"/></span></td><td align="left" valign="top" width="471"><b>22. Nazwisko</b><br/><br/><span class="cz18"><xsl:value-of select=".//@surname"/></span></td></tr><tr><td align="left" colspan="2" valign="top"><b>23.Numer telefonu i adres e-mail</b><br/><br/><span class="cz18"><xsl:value-of select=".//@phone"/>;</span><span class="cz18"><xsl:value-of select=".//@email"/></span></td></tr></table></xsl:template><xsl:template match="zpnw:Consignor | ns1:Consignor | tr:* | ns4:* | ns5:* | fr:*" mode="DaneNadawcy"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="4"><span class="nag1">C.DANE PODMIOTU NADAWCY<sup>1)</sup></span><br/> *- dotyczy podmiotów niebędących osobami fizycznymi **- dotyczy podmiotów będących osobami fizycznymi </td></tr><tr bgcolor="#CCCCCC"><td colspan="4"><span class="nag2">C.1 DANE IDENTYFIKACYJNE </span></td></tr><tr><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td align="left" colspan="3" valign="top"><b>23. Rodzaj podmiotu (zaznaczyć właściwy kwadrat): </b></td></tr><tr><td align="left" valign="top">1. podmiot niebędący osobą fizyczną<br/><xsl:for-each select=".//tr:TaxpayerData | .//ns4:TaxpayerData | .//fr:TaxpayerData"><b><span class="cz18">X</span></b></xsl:for-each></td><td align="left" valign="top" width="425">2. osoba fizyczna <br/><xsl:for-each select=".//tr:PrivatePerson | .//ns4:PrivatePerson  | .//fr:PrivatePerson"><b><span class="cz18">X</span></b></xsl:for-each></td></tr><tr><td align="left" colspan="3" valign="top"><b>24.Nazwa pełna podmiotu/ dane osobowe (imię, nazwisko, data urodzenia) </b><br/><br/><xsl:for-each select=".//tr:TaxpayerData | .//ns4:TaxpayerData | .//fr:TaxpayerData"><span class="cz18"><xsl:value-of select=".//@fullName"/></span><span class="cz18"><xsl:value-of select=".//@REGON"/></span></xsl:for-each><xsl:for-each select=".//tr:PrivatePerson | .//ns4:PrivatePerson | .//fr:PrivatePerson"><span class="cz18"><xsl:value-of select=".//@firstName"/></span><span class="cz18"><xsl:value-of select=".//@surname"/></span><span class="cz18"><xsl:value-of select=".//@dateOfBirth"/></span><span class="cz18"><xsl:value-of select=".//@PESEL"/></span></xsl:for-each></td></tr></table></xsl:template><xsl:template match="zpnw:Consignor | ns1:Consignor | tr:* | ns4:* | ns5:* | fr:*" mode="AdresNadawcy"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="6"><span class="nag2">C.2. ADRES SIEDZIBY* / ADRES ZAMIESZKANIA** </span></td></tr><tr align="left" valign="top"><td><b>25. Kraj </b><br/><span class="cz18"><xsl:value-of select=".//@country"/></span></td><td colspan="2"><b>26. Ulica</b><br/><span class="cz18"><xsl:value-of select=".//@street"/></span></td><td width="144"><b>27. Nr domu</b><br/><span class="cz18"><xsl:value-of select=".//@houseNumber"/></span></td><td width="151"><b>28. Nr lokalu</b><br/><span class="cz18"><xsl:value-of select=".//@localNumber"/></span></td></tr><tr align="left" valign="top"><td><b>29. Miejscowość</b><br/><span class="cz18"><xsl:value-of select=".//@city"/></span></td><td width="130"><b>30. Kod pocztowy</b><br/><span class="cz18"><xsl:value-of select=".//@postalCode"/></span></td><td width="181"><b>31. Poczta</b><br/><span class="cz18"><xsl:value-of select=".//@postalName"/></span></td><td colspan="2"><b> Adres e-mail i nr telefonu</b><br/><span class="cz18"><xsl:value-of select=".//@email"/>;</span><br/><span class="cz18"><xsl:value-of select=".//@phoneConsignor"/></span></td></tr></table><table width="955"><tr align="right" valign="top"><td colspan="3"><span class="nag1">ZPNW</span><sub style="cz9"/><b style="nag1">/1</b></td></tr></table></xsl:template><!-- SZABLON DOT. WYROBOW --><xsl:template match="ns1:* | zpnw:*" mode="Wyroby"><!-- ZNAK KONCA STRONY DO WYDRUKU --><div style="page-break-before: always"/><table border="1" width="955"><tr align="left" bgcolor="#CCCCCC" valign="top"><td colspan="6"><span class="nag1"><b>D. DANE WYROBÓW AKCYZOWYCH PRZEWIDYWANYCH DO NABYCIA</b></span></td></tr><tr align="left" bgcolor="#CCCCCC" valign="top"><td><span class="cz14"> Lp. </span></td><td><span class="cz14"> Szczegółowy opis wyrobów </span></td><td><span class="cz14">Kod CN </span></td><td><span class="cz14">Ilość / j. m. </span></td><td><span class="cz14">Stawka akcyzy </span></td><td><span class="cz14">Kwota akcyzy w zł <sup>3)</sup></span></td></tr><xsl:for-each select="//zpnw:Item | //ns1:Item"><tr><td><br/><div align="right" class="cz18" valign="top"><xsl:value-of select="@id"/></div></td><td><div align="left" class="cz14" valign="top"><xsl:value-of select="@goodsName"/></div><div align="left" class="cz14" valign="top"><i><b><xsl:value-of select="@groupOfGoodsName"/></b></i></div></td><td><div align="right" class="cz18" valign="top"><xsl:value-of select="@codeCN"/></div></td><td><div align="right" class="cz18" valign="top"><xsl:value-of select="@valueOfGoods"/></div><div align="right" class="cz18" valign="top"><xsl:value-of select="@numberOfGoods"/></div><div align="right" class="cz14" valign="top"><xsl:value-of select="@unitOfMeasure"/></div></td><td><div align="right" class="cz18" valign="top"><xsl:value-of select="@taxRatePercentage"/></div><div align="right" class="cz18" valign="top"><xsl:value-of select="@taxRate"/></div></td><td><div align="right" class="cz18" valign="top"><xsl:value-of select="format-number(number(@amountOfTax),'# ##0')"/></div></td></tr></xsl:for-each></table></xsl:template><!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --><xsl:template match="*" mode="OswPodatnika"><xsl:if test="ns1:* | ns3:* | zpnw:* | tp:*"><table border="1" height="210" width="955"><tr align="left" bgcolor="#CCCCCC" valign="top"><td colspan="3"><b><span class="nag1">E. OŚWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJĄCEJ PODATNIKA</span></b><br/> Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za podanie danych niezgodnych z rzeczywistoscią.</td></tr><tr align="left" valign="top"><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td height="37" width="402"><b>32. Imię </b><br/><br/><span class="cz18"><xsl:value-of select="//@repFirstName"/></span></td><td width="491"><b>33. Nazwisko </b><br/><br/><span class="cz18"><xsl:value-of select="//@repSurname "/></span></td></tr><tr align="left" valign="top"><td height="39"><b>34. Data wypełnienia deklaracji (dzień-miesiąc-rok) </b><br/><br/><br/><span class="cz18"><xsl:value-of select="//@declarationDate"/></span></td><td><b>35. Podpis (i pieczątka) podatnika lub osoby reprezentującej podatnika </b></td></tr><tr align="left" valign="top"><td colspan="2" height="70"><b>36. Numer telefonu i adres e-mail podatnika lub osoby reprezentującej podatnika </b><br/><br/><span class="cz18"><xsl:value-of select="//@phone"/>, <xsl:value-of select="ns1:Statement/ns3:representative/@email"/></span></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. ADNOTACJI--><xsl:template match="*" mode="Adnotacje"><xsl:if test="ns1:* | zpnw:*"><table border="1" height="167" width="955"><tr bgcolor="#CCCCCC"><td class="nag1" colspan="3" height="36">F. ADNOTACJE URZĘDU CELNEGO </td></tr><tr align="left" bgcolor="#CCCCCC" valign="top"><td rowspan="2" width="40"/><td colspan="2" height="72"><b>37.Uwagi urzędu celnego <br/><br/><br/><br/><br/><br/><br/></b></td></tr><tr align="left" bgcolor="#CCCCCC" valign="top"><td height="49" width="472"><b>38. Identyfikator przyjmującego formularz <br/><br/><br/></b><p/></td><td width="421"><b>39. Podpis przyjmującego formularz </b></td></tr></table><table width="955"><tr align="right" valign="top"><td colspan="3"><span class="nag1">ZPNW</span><sub style="cz9"/><b style="nag1">/2</b></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--><xsl:template match="*" mode="ObjasnieniaAkc"><xsl:if test="ns1:* | zpnw:*"><table width="955"><tr><td><p><sup>1)</sup>należy podać imię i nazwisko albo nazwę oraz adres zamieszkania lub siedziby oraz numer identyfikacji podatkowej NIP.</p><p><sup>2)</sup>kwota zabezpieczenia akcyzowego obejmuje mogące powstać zobowiązanie podatkowe albo mogące powstać zobowiązanie podatkowe oraz opłatę paliwową, której obowiązek zapłaty może powstać.</p><p><sup>3)</sup>kwotę zabezpieczenia akcyzowego i kwotę akcyzy zaokrągla się do pełnych złotych w ten sposób, że końcówki kwot wynoszące mniej niż 50 groszy pomija się, a końcówki kwot wynoszące 50 i więcej groszy podwyższa się do pełnych złotych - zgodnie z art. 63 § 1 ustawy z dnia 29 sierpnia 1997 r. - Ordynacja podatkowa (Dz. U. z 2015 r. poz. 613, z późn. zm.).</p></td></tr></table></xsl:if></xsl:template><!-- KONIEC all GS--></xsl:stylesheet>